package gov.va.med.mhv.bluebutton.bbdownload.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.client.WebClient;

public class BlueButtonUtil {

	public static String RFC1123_PATTERN  =	"EEE, dd MMM yyyy HH:mm:ss z";
	
	public static String convertDateToRFC1123Pattern(Date dt ) {
		SimpleDateFormat formatter = new SimpleDateFormat(RFC1123_PATTERN);
		String reportDate = formatter.format(dt);
		return reportDate;

	}
	
	public static Date convertRFC1123PatterntoDate(String dateString ) {
		SimpleDateFormat formatter = new SimpleDateFormat(RFC1123_PATTERN);
		Date date = null;
		try {
			date = formatter.parse(dateString);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
		return date;

	}
	
	public static String formatErrorMessage(WebClient client,
			Response webserviceResponse) {
		StringBuffer sb = new StringBuffer();
		sb.append("Invalid Response to webservice call")
				.append(",Webservice URL:").append(client.getCurrentURI())
				.append(",Status code:")
				.append(webserviceResponse.getStatusInfo().getStatusCode())
				.append(",Reason:")
				.append(webserviceResponse.getStatusInfo().getReasonPhrase());
		return sb.toString();
	}

	
}
